--For debugging
function fakeSong()
	local mt = {
		__index = {
			GetDisplayMainTitle = function()
				return "Debug Testing Song";
			end;
			GetJacketPath = function()
				return THEME:GetPathG("common", "fallback jacket");
			end;
			HasJacket = function()
				return true;
			end;
		};
	};
	return setmetatable({}, mt)
end;

--TODO: Return fake song class when in debug mode.
local song;
if _G.themeDebug then
	song = fakeSong();
else
	song = GAMESTATE:GetCurrentSong();
end;
local jacketBorderThickness = 2;

--[[local function difficultyToColor(diffname)
    local squareColor;
    if diffname == "Beginner" then
        squareColor = "#33B5E5";
    elseif diffname == "Easy" then
        squareColor = "#FFBB33";
    elseif diffname == "Medium" then
        squareColor = "1,0,1,1";
    elseif diffname == "Hard" then
        squareColor = "#39b54a";
    elseif diffname == "Challenge" then
        squareColor = "#9900ff";
    end;
    return squareColor;
end;]]

--Make global?
local DifficultyCustomNames = {
	Difficulty_Beginner	 = "Beginner",
	Difficulty_Easy		 = "Easy",
	Difficulty_Medium	 = "Medium",
	Difficulty_Hard		 = "Hard",
	Difficulty_Challenge = "Challenge",
	Difficulty_Edit		 = "Insane"
};



local t = Def.ActorFrame{};

--Special background (get A, AA, or AAA)
local highestGrade;

if _G.themeDebug == false then
	--The Grade:Reverse()[grade] turns the grade into a number
	local gradeP1 = Grade:Reverse()[STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetGrade()];
	local gradeP2 = Grade:Reverse()[STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetGrade()];
	if gradeP1 > gradeP2 then highestGrade = gradeP1 else highestGrade = gradeP2 end;
else
	highestGrade = _G.DebugGrade;
end;

if highestGrade <= 2 or (_G.DebugGoToExtra and _G.themeDebug) then
	--SCREENMAN:SystemMessage(highestGrade);
	local gradeLetter = getGradeLetter(highestGrade);
	local course = _G.CurrentFakeCourse;
	--SCREENMAN:SystemMessage(tostring(highestGrade).. " "..gradeLetter);
	--[[
		After a course song, if a results screen image exists for that stage of the course,
		display it.
		Additionally, if there is a teaser image for the Extra Stage or One More Extra Stage, show that
		before going into the next stage.
	]]
	local uniqueBG = true;
	if course then
		local dir = course:GetCourseDir():sub(1, -5)
		local n = _G.StageIndex;
		--So I guess images on pixiv are always jpg for some reason
		local filepath = dir.."/Stage"..n.."_Results.jpg";
		local filepathEX = dir.."/EXTeaser_Results.png";
		local filepathOMES = dir.."/OMESTeaser_Results.png";
		if n < 4 and FILEMAN:DoesFileExist(filepath) then
			t[#t+1] = LoadActor(filepath)..{
				InitCommand=cmd(Center;scaletocover,SCREEN_LEFT,SCREEN_TOP,SCREEN_RIGHT,SCREEN_BOTTOM);
			};
		elseif n == 4 and FILEMAN:DoesFileExist(filepathEX) then
			t[#t+1] = LoadActor(filepathEX)..{
				InitCommand=cmd(Center;scaletocover,SCREEN_LEFT,SCREEN_TOP,SCREEN_RIGHT,SCREEN_BOTTOM);
			};
		elseif n == 5 and FILEMAN:DoesFileExist(filepathOMES) then
			t[#t+1] = LoadActor(filepathOMES)..{
				InitCommand=cmd(Center;scaletocover,SCREEN_LEFT,SCREEN_TOP,SCREEN_RIGHT,SCREEN_BOTTOM);
			};
		elseif _G.DebugGoToExtra then
			if FILEMAN:DoesFileExist(filepathEX) then
				t[#t+1] = LoadActor(filepathEX)..{
					InitCommand=cmd(Center;scaletocover,SCREEN_LEFT,SCREEN_TOP,SCREEN_RIGHT,SCREEN_BOTTOM);
				};
			else
				SCREENMAN:SystemMessage(filepathEX.." doesn't exist!");
				--SCREENMAN:SystemMessage(dir);
				uniqueBG = false;
			end;
		elseif _G.DebugGoToOMES then
			if FILEMAN:DoesFileExist(filepathOMES) then
				t[#t+1] = LoadActor(filepathOMES)..{
					InitCommand=cmd(Center;scaletocover,SCREEN_LEFT,SCREEN_TOP,SCREEN_RIGHT,SCREEN_BOTTOM);
				};
			else
				SCREENMAN:SystemMessage(filepathOMES.." doesn't exist!");
				--SCREENMAN:SystemMessage(dir);
				uniqueBG = false;
			end;
		else
			uniqueBG = false;
		end;
	else
		if _G.themeDebug then
			--SCREENMAN:SystemMessage("No FakeCourse.");
		end;
		uniqueBG = false;
	end;
	--[[if uniqueBG == false then
		t[#t+1] = randomBackground("_result images/"..gradeLetter.."_result");
	end;]]			
end;

--==================
-- Extra Stage stuff
--==================
--[[
	0 = did not unlock
	1 = Extra
	2 = OMES
]]
local unlockedExtraStage = 0;
if (_G.FakeCourse and GAMESTATE:GetCurrentStageIndex() == 4 and highestGrade > 3) or _G.DebugGoToExtra then
	unlockedExtraStage = 1;
elseif (_G.FakeCourse and GAMESTATE:GetCurrentStageIndex() == 5 and highestGrade > 3) or _G.DebugGoToOMES then
	unlockedExtraStage = 2;
end
if unlockedExtraStage > 0 then
	t[#t+1] = Def.ActorFrame{

		--[[Def.Quad{
			InitCommand=cmd(setsize,430,25;fadeleft,.3;faderight,.3;xy,SCREEN_CENTER_X,SCREEN_CENTER_Y+200;diffuse,Color("Black"););
		
		};]]
		
		LoadFont("Common Label")..{
			InitCommand=function(self)
				if unlockedExtraStage == 2 then
					self:settext("Continue to Phantasm Stage");
				else
					self:settext("Continue To Extra Stage");
				end;
				self:uppercase(true);
				self:horizalign(center);
				self:Center();
				--self:zoom(2);
				self:addy(250);
				--self:rainbowscroll(true);
				--SCREENMAN:SystemMessage("Debug Extra is on, game will always go to extra stage.");
			end;
		};

	};
end;


t[#t+1] = Def.ActorFrame{
	--=================
	-- Jacket & lines
	--=================
	--InitCommand=cmd(addx,400);
	Def.Quad{
		OnCommand=function(self)
			if song:HasJacket() then
				local jacket = song:GetJacketPath();
				self:Load(jacket);
				--local bgWidth = self:GetWidth();
				--self:x(bgWidth/2); --SM centers graphics, so find center
				--self:addx(-20); --Shift to the left a bit because the song wheel covers some stuff
				self:diffusealpha(1);
				self:Center();
			else
				self:diffusealpha(0);
				--self:Load();
			end;
			self:SetSize(300,300);
		end;
	};
	Def.ActorFrame{
		OnCommand=function(self)
			 if song:HasJacket() then
				self:diffusealpha(1);
			else
				self:diffusealpha(0);
				--self:Load();
			end;
		end;
		
		--Top line
		Def.Quad{
			InitCommand=cmd(setsize,SCREEN_CENTER_X + 150 + jacketBorderThickness, jacketBorderThickness;y,SCREEN_CENTER_Y-150;horizalign,0;vertalign,2);

		};
		--Bottom line
		Def.Quad{
			InitCommand=cmd(setsize,SCREEN_CENTER_X + 150 + jacketBorderThickness, jacketBorderThickness;y,SCREEN_CENTER_Y+150;x,SCREEN_RIGHT;horizalign,2;vertalign,0); --2 = right aligned
		};
		--Left line
		Def.Quad{
			InitCommand=cmd(setsize,jacketBorderThickness, SCREEN_CENTER_Y + 150 + jacketBorderThickness;x,SCREEN_CENTER_X-150;y,0;vertalign,0;horizalign,2); --2 = right aligned
		};
		--Right line
		Def.Quad{
			InitCommand=cmd(setsize, jacketBorderThickness, SCREEN_CENTER_Y + 150 + jacketBorderThickness;x,SCREEN_CENTER_X+150;y,SCREEN_BOTTOM;vertalign,2;horizalign,0); --2 = bottom aligned
		};
	};
	
};
--==================
-- Song title
--==================
t[#t+1] = Def.ActorFrame{

	InitCommand=cmd(Center;addy,200;);
	
	OnCommand=function(self)
		local width = self:GetChild("title"):GetWidth();
		if width < 50 then
			width = 50;
		end;
		self:GetChild("bg"):setsize(width*1.5,30);
	end;

	Def.Quad{
		Name="bg";
		InitCommand=cmd(diffuse,color("0,0,0,.8");fadeleft,.15;faderight,.15);
	};
	-- Song title
	LoadFont("Common Normal")..{
		Name="title";
		InitCommand=function(self)
			self:settext(song:GetDisplayMainTitle());
		end;
		OnCommand=cmd(diffuse,color("1,1,1,1");--[[shadowcolor,Color("White");shadowlength,1]])
	};
};

--==================
-- Player 1 scores
--==================
if GAMESTATE:IsSideJoined(PLAYER_1) or _G.themeDebug == true then
	local grade;
	if _G.themeDebug then
		grade = _G.DebugGrade;
	else
		grade = gradeToNumber(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetGrade());
	end;
	
	t[#t+1] = LoadActor("playerResults",PLAYER_1)..{
		OnCommand=cmd(x,260;y,SCREEN_CENTER_Y;zoom,1.5)
	};


	t[#t+1] = Def.ActorFrame{
		InitCommand=cmd(x,66;y,SCREEN_CENTER_Y;);
		
		squareGen(150, 2.5, color("0,0,0,.7"))..{
			OnCommand=cmd(addrotationz,45);
		};
		
		LoadFont("Dialogue Stage Titles")..{
			Text=getGradeLetter(grade);
			OnCommand=function(self)
				--SCREENMAN:SystemMessage(getGradeLetter(grade));
				if grade == 4 then
					self:diffusebottomedge(Color("Yellow"));
				elseif grade == 3 then
					self:diffusebottomedge(Color("Green"))
				elseif grade <= 2 then
					self:diffusebottomedge(Color("Blue"));
				else
					self:diffusebottomedge(Color("Red"));
				end;
			end;
		};
	};

	local steps = GAMESTATE:GetCurrentSteps(PLAYER_1);
	local diffname;
	if _G.themeDebug == true then
		diffname = "Beginner";
	else
		diffname = ToEnumShortString(steps:GetDifficulty());
	end;
	
	--Steps square
	t[#t+1] = Def.ActorFrame{
		InitCommand=cmd(x,84;y,SCREEN_CENTER_Y+195;);
		
		squareGen(150, 2.5, _G.diffColors[diffname])..{
			OnCommand=cmd(addrotationz,45)
		};
		LoadFont("Common Label")..{
			OnCommand=function(self)
				if not steps then
					self:settext(-1);
				else
					local difficultyNum = steps:GetMeter();
					self:settext(difficultyNum);
				end;
			end;
		};
		
		LoadFont("Common Normal")..{
			Text=diffname;
			InitCommand=cmd(addy,20;zoom,.5);
		};
	};
	--[[t[#t+1]= LoadActor("ScoreGraph", PLAYER_1)..{
			--250 is the area of the jacket
			InitCommand=cmd(xy,SCREEN_WIDTH*.75+250/4,SCREEN_CENTER_Y;);
		};]]
end;

--===================
-- Player 2 scores
--===================
if GAMESTATE:IsSideJoined(PLAYER_2) then
	t[#t+1] = LoadActor("playerResults", PLAYER_2)..{
		OnCommand=cmd(x,SCREEN_RIGHT - 260;y,SCREEN_CENTER_Y;zoom,1.5)
	};

	local grade = gradeToNumber(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetGrade());
	
	t[#t+1] = Def.ActorFrame{
		InitCommand=cmd(x,SCREEN_RIGHT-66;y,SCREEN_CENTER_Y;);
		
		squareGen(150, 2.5, color("0,0,0,.7"))..{
			OnCommand=cmd(addrotationz,45);
		};
		
		LoadFont("Dialogue Stage Titles")..{
			Text=getGradeLetter(grade);
			OnCommand=function(self)
				--SCREENMAN:SystemMessage(getGradeLetter(grade));
				if grade == 4 then
					self:diffusebottomedge(Color("Yellow"));
				elseif grade == 3 then
					self:diffusebottomedge(Color("Green"))
				elseif grade <= 2 then
					self:diffusebottomedge(Color("Blue"));
				else
					self:diffusebottomedge(Color("Red"));
				end;
			end;
		};
	};

	local steps = GAMESTATE:GetCurrentSteps(PLAYER_2);
	local diffname = ToEnumShortString(steps:GetDifficulty());

	t[#t+1] = Def.ActorFrame{
		InitCommand=cmd(x,SCREEN_RIGHT-84;y,SCREEN_CENTER_Y-195;);
		
		squareGen(150, 2.5, _G.diffColors[diffname])..{
			OnCommand=cmd(addrotationz,45)
		};
		LoadFont("Common Normal")..{
			OnCommand=function(self)
				if not steps then
					self:settext(-1);
				else
					local difficultyNum = steps:GetMeter();
					self:settext(difficultyNum);
				end;
			end;
		};
		
		LoadFont("Common Normal")..{
			Text=diffname;
			InitCommand=cmd(addy,20;zoom,.5);
		};
	};
end;

--t[#t+1] = LoadActor("Graphs", PLAYER_1);

t[#t+1] = Def.ActorFrame{
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			if not _G.CurrentFakeCourse then
				local stage;
				if themeDebug then
					stage = "Debug";
				else
					stage = ToEnumShortString(STATSMAN:GetCurStageStats():GetStage());
				end;
				if stage == "Extra1" then
					self:settext("Extra Stage Results");
				elseif stage == "Extra2" then
					self:settext("Phantasm Stage Results");
				else
					self:settext(stage.." Stage Results");
				end;
			else
				if _G.StageIndex == 0 then
					self:settext("Tutorial Stage Results");
				else
					if _G.StageType == 1 then
						self:settext("Stage ".._G.StageIndex.." Results");
					elseif _G.StageType == 2 then
						self:settext("Extra Stage Results");
					else
						self:settext("Phantasm Stage Results");
					end;
				end;
			end;
		end;
		OnCommand=cmd(xy,SCREEN_CENTER_X,20;diffuse,Color("White"));
	};
};

return t;
